;=====================================================================
; Device      : AD18F08
; Author      : AD Application Team
; Version     : V0.0.1
; Date        : 20211016
; Description : 定时器0 定时10ms，中断里面PB0翻转，主循环PA1翻转
;=====================================================================
include "AD18F08.inc"


;----- CONFIG Options Begin--------------------------------------------------

ORG		300000H
DW _FINTOSC_DIV1_1L   & _DBG_OFF_2L        & _LVREN_ON_1L    & _LVR24V_1L
DW _FLASH_CP1_OFF_2L  & _FLASH_CP0_OFF_2L  & _IDIS_OFF_2L    & _CKSUM_OFF_2L & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L
DW _PSUT_1_3L         & _FCPU_4T_3L        & _WDTE_OFF_3L    & _TWDT_000_3L
DW _OSCM_HIRC_16M_4L  & _MTPDIS_OFF_4L     & _ADCSP_ON_4L
;=====================================================================
;-------------------------- ROM AREAS --------------------------------
;=====================================================================
	ORG		0000H			;复位地址
	GOTO	MAIN

	ORG		0008H			;硬件中断地址，高优先级
	GOTO    HINTERR

	ORG		0018H			;硬件中断地址，低优先级
	GOTO    LINTERR
;=====================================================================
;---------------- INTERRUPT PROGRAMME BEGINNING ----------------------
;=====================================================================




       HINTERR  BTFSC PIR1, TMR0IF
			   BTFSS PIE1, TMR0IE
               GOTO REGRESO
               BCF PIR1, TMR0IF
               MOVLW 0x0F
               XORWF PORTB,0x0F ; PB0翻转
               goto  INT_EXIT
       LINTERR


              goto  INT_EXIT

       INT_EXIT
              REGRESO RETFIE




;=====================================================================
;------------------ MAIN PROGRAMME BEGINNING -------------------------
;=====================================================================
MAIN MOVLW 0X01
     MOVLB 0x0F
     BSF CLKCFG1,T0CLKEN

     MOVLW 0X07
     MOVWF T0CON


     MOVLW 0X9C
     MOVWF PR0

     CLRF TMR0

     CLRF  TRISB

     MOVLW B'00000000' ;PORTA全设为输出
     MOVWF TRISA


     BSF IPR1,TMR0IP
     BCF PIR1,TMR0IF
     BSF PIE1,TMR0IE

	BSF PCON,IPEN
     ;使能中断优先级
     BSF INTCON,GIEH
     ;使能高优先级全局中断

;主循环------------------------------------
     CYCLE
          NOP
          MOVLW 0x0F
          XORWF PORTA,0x0F ; PA翻转
     GOTO CYCLE


END
